/***********************************************************************
 * \file: util_hash_i.h
 * 
 * \version: $Revision: 1.2 $
 * 
 * \release: $Name: UTIL_r2_E05 $
 *
 * Internal interface for hash table with chaining.
 * 
 * \component: Utility
 * 
 * \author T. Polle / ADIT / SWG / tpolle(o)de.adit-jv.com
 * 
 * \copyright: (c) 2003 - 2008 ADIT Corporation 
 *
 ***********************************************************************/
#ifndef UTIL_HASH_I_H
#define UTIL_HASH_I_H

#ifdef __cplusplus
extern "C" {
#endif

typedef struct UTIL_hash_bucket_t UTIL_hash_bucket_t;
struct UTIL_hash_bucket_t
{
  UTIL_hash_bucket_t*  next;
  UTIL_hash_elem_t     elem;
};

struct UTIL_hash_table_t
{
  U32                    nel;
  UTIL_hash_cmp_fn      func;
  UTIL_hash_bucket_t**  buckets;
  UTIL_mpf_t*           bucket_pool;
};

#ifdef __cplusplus
};
#endif

#endif /* UTIL_HASH_I_H */
